from median.models import Magasin, Poste, Espace, CatalogVersion, CatalogUnitStock, CatalogLines, \
    CatalogColumns, Adresse, Service, EquipmentUnitStock, EquipmentLines, EquipmentColumns


def init_equipment(data):
    equipment = Magasin()
    equipment.id_zone = data.get('id_zone', '')
    equipment.id_robot = data.get('id_robot', '')
    equipment.type_mag = data['type_mag']
    equipment.mag = data['mag']
    equipment.libelle = data['libelle']
    equipment.type_machine = data['version']

    return equipment


def remove_equipment(equipment):
    if equipment is not None and equipment.pk is not None:
        Poste.delete().where(Poste.poste == equipment.type_mag).execute()
        Service.delete().where(Service.secteur == equipment.type_mag).execute()
        Espace.delete().where(Espace.poste == equipment.type_mag).execute()
        Adresse.delete().where(Adresse.magasin == equipment.mag).execute()

        unitPks = EquipmentUnitStock.select(EquipmentUnitStock.pk).where(
            EquipmentUnitStock.equipment_pk == equipment.pk)
        lines_pks = EquipmentLines.select(EquipmentLines.pk).where(EquipmentLines.unit_stock_pk << unitPks)
        EquipmentColumns.delete().where(EquipmentColumns.line_pk << lines_pks).execute()
        EquipmentLines.delete().where(EquipmentLines.unit_stock_pk << unitPks).execute()
        EquipmentUnitStock.delete().where(EquipmentUnitStock.equipment_pk == equipment.pk).execute()

        Magasin.delete().where(Magasin.pk == equipment.pk).execute()


def add_poste_espace(equipment):
    # f_poste
    poste = Poste()
    poste.poste = equipment.type_mag
    poste.pc = 'MEDIAN'
    poste.save()

    # f_espace
    espace = Espace()
    espace.poste = equipment.type_mag
    espace.mag = equipment.mag
    espace.save()


def getColumns_version(version, sub_version=''):
    return (CatalogVersion.select(CatalogVersion, CatalogUnitStock, CatalogLines, CatalogColumns)
            .join(CatalogUnitStock, on=CatalogUnitStock.version_pk == CatalogVersion.pk)
            .switch(CatalogVersion)
            .join(CatalogLines, on=CatalogLines.unit_stock_pk == CatalogUnitStock.pk)
            .switch(CatalogVersion)
            .join(CatalogColumns, on=CatalogColumns.line_pk == CatalogLines.pk)
            .where((CatalogVersion.numVersion == version) & (CatalogVersion.subVersion == sub_version)))


def create_equipment_topo(numversion, equipment):
    catalogUnitStocks = (CatalogUnitStock.select(CatalogUnitStock)
                         .join(CatalogVersion, on=CatalogVersion.pk == CatalogUnitStock.version_pk)
                         .where(CatalogVersion.numVersion == numversion))

    for catalog_unit_stock in catalogUnitStocks:
        eq_stock = EquipmentUnitStock()
        eq_stock.order = catalog_unit_stock.order
        eq_stock.equipment_pk = equipment.pk
        eq_stock.total_colonne = catalog_unit_stock.total_colonne
        eq_stock.total_line = catalog_unit_stock.total_line
        eq_stock.save()
        catalog_lines = CatalogLines.select(CatalogLines).where(CatalogLines.unit_stock_pk == catalog_unit_stock.pk)

        for catalog_line in catalog_lines:
            eq_lines = EquipmentLines()
            eq_lines.start_line = catalog_line.start_line
            eq_lines.end_line = catalog_line.end_line
            eq_lines.unit_stock_pk = eq_stock.pk
            eq_lines.save()

            catalog_cols = CatalogColumns.select(CatalogColumns).where(CatalogColumns.line_pk == catalog_line.pk)

            for catalog_col in catalog_cols:
                eq_cols = EquipmentColumns()
                eq_cols.line_pk = eq_lines.pk
                eq_cols.start_column = catalog_col.start_column
                eq_cols.end_Column = catalog_col.end_Column
                eq_cols.container_type = catalog_col.container_type
                eq_cols.save()
