from median.constant import EcoType, EtatAdresse
from median.models import Adresse

from ressources.equipments.store_utils import init_equipment, add_poste_espace, remove_equipment

from ressources.equipments.store_utils import create_equipment_topo

from ressources.equipments.Version import EquipmentType


def generate_external(data):
    type = data['type']
    version = data['version']
    equipment = None
    if type == EquipmentType.EXTERNE.value:

        depths = int(data.get('PROFONDEUR', 1))
        lines = int(data.get('LIGNE', 1))
        columns = int(data.get('COLONNE', 1))

        equipment = init_equipment(data)
        equipment.eco_type = EcoType.Externe.value
        equipment.nb_dim = 4
        equipment.lib_2 = 'LIGNE'
        equipment.dim_2 = lines
        equipment.lib_3 = 'COLONNE'
        equipment.dim_3 = columns
        equipment.lib_4 = 'PROFONDEUR'
        equipment.dim_4 = depths
        equipment.save()

        create_equipment_topo(equipment=equipment, numversion=version)

        try:

            for line in range(lines):
                for col in range(columns):
                    for depth in range(depths):
                        add_external_adresse(equipment=equipment,
                                             address_label=f'{equipment.mag}'
                                                           f'.{line+1:03}'
                                                           f'.{col+1:03}'
                                                           f'.{depth+1:03}')

            add_poste_espace(equipment)

        except Exception:
            remove_equipment(equipment)

    return equipment


def add_external_adresse(equipment, address_label):
    address = Adresse()
    address.adresse = address_label
    address.magasin = equipment.mag
    address.etat = EtatAdresse.Libre.value
    address.nb_div = 1
    address.dim_x = 1
    address.dim_y = 1
    address.princ = 1
    address.save()
