from median.constant import EcoType, EtatAdresse
from median.models import Adresse

from ressources.equipments.store_utils import getColumns_version, init_equipment, add_poste_espace
from ressources.equipments.store_utils import remove_equipment

from ressources.equipments.Version import EquipmentType


def topo_astus(unit_stock, column, line, col, sub_version):
    adresses = []
    v = str(chr(line + ord('A')))
    if column.container_type.startswith('BAC'):
        for d in range(2 if sub_version != 'XL' else 1):
            offset = unit_stock.total_colonne * unit_stock.order
            adresses.append(
                f'{"{: >3}".format(v)}.'
                f'{"{: >3}".format(str(offset + col + 1))}.'
                f'{"{: >3}".format(str(d + 1))}')

    return adresses


def generate_astus(data):
    type = data['type']
    version = data['version']
    if type == EquipmentType.ASTUS.value:

        depths = int(data['PROFONDEUR'])
        columns_version = getColumns_version(version=data['version'], sub_version=data['subVersion'])

        equipment = init_equipment(data)
        equipment.eco_type = EcoType.Astus.value
        equipment.type_machine = version
        equipment.nb_dim = 4
        equipment.lib_2 = 'LIGNE'
        equipment.dim_2 = columns_version[0].catalogunitstock.total_line
        equipment.lib_3 = 'COLONNE'
        equipment.dim_3 = columns_version[0].catalogunitstock.total_colonne
        equipment.lib_4 = 'PROFONDEUR'
        equipment.dim_4 = depths
        equipment.lib_5 = 'STUPEFIANT'
        equipment.dim_5 = 0
        equipment.save()

        try:
            for column in columns_version:
                for line in range(column.cataloglines.start_line, column.cataloglines.end_line + 1):
                    for col in range(column.catalogcolumns.start_column, column.catalogcolumns.end_Column + 1):
                        for depth in range(depths):
                            address = Adresse()
                            address.adresse = (f'{equipment.mag}'
                                               f'.{"{: >3}".format(chr(65 + line))}'
                                               f'.{"{: >3}".format(str(col + 1))}'
                                               f'.{"{: >3}".format(str(depth + 1))}')
                            address.magasin = equipment.mag
                            address.etat = EtatAdresse.Libre.value
                            address.nb_div = 1
                            address.dim_x = 1
                            address.dim_y = 1
                            address.princ = 1
                            address.format = column.catalogcolumns.container_type
                            address.save()

            add_poste_espace(equipment)

            return equipment
        except Exception:
            remove_equipment(equipment)
