from enum import Enum

from common.dto import Dto


class State(Enum):
    Success = 0
    Waiting = 1


class TransfertDTO(Dto):
    def __init__(self, pk, username, function, poste,
                 nb_retry, delete, chrono):
        self.pk = pk
        self.username = username
        self.function = function
        self.poste = poste
        self.nb_retry = nb_retry
        self.delete = delete
        self.chrono = str(chrono.astimezone()) if chrono is not None else ''


class TransfertItemDTO(Dto):
    def __init__(self, pk, username, function, poste,
                 nb_retry, error_msg, delete, params, chrono, url, wsdl, retry_date):
        self.pk = pk
        self.username = username
        self.function = function
        self.poste = poste
        self.nb_retry = nb_retry
        self.error_msg = error_msg
        self.delete = delete
        self.xml_params = params
        self.chrono = str(chrono.astimezone()) if chrono is not None else ''
        self.url = url
        self.wsdl = wsdl
        self.retry_date = str(retry_date.astimezone()) if retry_date is not None else ''
