import datetime
import logging
import os
from pathlib import Path

from common.status import HTTP_404_NOT_FOUND
from flask import Blueprint
from flask_jwt_extended import jwt_required

reporting_blueprint = Blueprint('reporting', __name__)

logger = logging.getLogger('median')

cr_folder = os.environ.get('REPORTING_FOLDER', '.')


@reporting_blueprint.route('', methods=['GET'])
@jwt_required()
def get_all():
    """
    Retrieve the liste of the PDF file, group by date
    """
    result = []
    p = Path(cr_folder)
    if not p.exists():
        return {
            'message': 'Folder does not exists!',
            'folder': cr_folder,
        }, HTTP_404_NOT_FOUND

    nb_files = 0
    files = __get_files(('*.csv', '*.pdf', '*.xls', '*.xlsx', '*.odt', '*.ods', '*.doc', '*.docx'),
                        cr_folder)
    for f in files:
        dtf = datetime.datetime.fromtimestamp(os.path.getctime(f)).strftime('%Y-%m-%d')

        file_stats = os.stat(f)
        result.append({'date': dtf,
                       'extension': Path(f.name).suffix,
                       'name': f.name,
                       'size': file_stats.st_size,
                       'file': '/download/%s' % f.name,
                       'timestamp': os.path.getctime(f)})
        nb_files += 1

    if nb_files > 0:
        return result

    return {
        'message': 'No files available!',
        'folder': cr_folder,
    }, HTTP_404_NOT_FOUND


def __get_files(extensions, folder):
    all_files = []
    for ext in extensions:
        all_files.extend(Path(folder).glob(ext))
    return all_files
