import json

from common.status import HTTP_200_OK, HTTP_204_NO_CONTENT
from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from median.models import Product, Ucd, Stock, Cip, Config

reference_blueprint = Blueprint('reference', __name__)


def get_obj_acced(ref):
    return {

    }


def get_obj_astus(ref):
    return {
        'unit_gest': ref.unit_gest,
        'unit_admin': ref.unit_admin,
        'coef_conv': ref.coef_conv,
        'delai_peremp': ref.delai_peremp,
        'multidose_par_uf': ref.multidose_par_uf,
        'conversion_ucd': ref.conversion_ucd,
        'warn_pct': ref.warn_pct
    }


def get_obj_riedl(ref):
    return {
        'condi': ref.condi,
        'forme': ref.forme,
        'cip': ref.cip
    }


@reference_blueprint.route('/synchrocip', methods=['GET'])
@jwt_required()
def get_synchro_cip_info():

    res = (Config.select(Config.propriete, Config.value, Config.hierarchie_menu)
           .where((Config.poste == 'TOUS') &
                  (Config.cle == 'cfg') &
                  (Config.propriete << ['k_synchrocip_date', 'k_synchrocip_fichier_date'])))

    return {
        'data': [
            {
                'property': item.propriete,
                'value': item.value,
                'info': item.hierarchie_menu
            } for item in res
        ]
    }, HTTP_200_OK


def get_obj_external(ref):
    return {
        'qml_cde': ref.qml_cde,
        'qml_serv': ref.qml_serv,

    }


@reference_blueprint.route('/<string:reference_pk>/<string:eco_type>', methods=['PATCH'])
@jwt_required()
def update(reference_pk, eco_type):
    data = json.loads(request.data)

    req = (Product.select(Product)
           .where(Product.pk == reference_pk).get())

    if eco_type == 'L':  # Riedl
        req.condi = data['condi']
        req.forme = data['forme']
        req.cip = data['cip']
        req.save()
    elif eco_type == 'A':  # Astus
        req.unit_gest = data['unit_gest']
        req.unit_admin = data['unit_admin']
        req.coef_conv = int(data['coef_conv'])
        req.delai_peremp = int(data['delai_peremp'])
        req.multidose_par_uf = data['multidose_par_uf']
        req.conversion_ucd = data['conversion_ucd']
        req.warn_pct = int(data['warn_pct'])
        req.save()
    elif eco_type == 'E':  # External
        req.qml_cde = data.get('qml_cde', 0)
        req.qml_serv = data.get('qml_serv', 0)
        req.save()

    return {'data': 'success'}, HTTP_200_OK


@reference_blueprint.route('/<string:reference_pk>/<string:eco_type>', methods=['GET'])
@jwt_required()
def get_all(reference_pk, eco_type):
    req = (Product.select(Product)
           .where(Product.pk == reference_pk).get())

    obj = None
    if eco_type == 'L':  # Riedl
        obj = get_obj_riedl(req)
    elif eco_type == 'A':  # Astus
        obj = get_obj_astus(req)
    elif eco_type == 'E':  # External
        obj = get_obj_external(req)

    return {'data': obj
            }, HTTP_200_OK


@reference_blueprint.route('/<string:reference_pk>/ucds', methods=['GET'])
@jwt_required()
def get_ref_ucds(reference_pk):
    req = (Ucd.select(Ucd.pk, Ucd.ucd)
           .join(Product, on=Ucd.reference == Product.reference)
           .where(Product.pk == reference_pk))

    return {'list': [
        {
            'pk': item.pk,
            'label': item.ucd
        } for item in req
    ]}, HTTP_200_OK


@reference_blueprint.route('/<string:reference_pk>/batchs', methods=['GET'])
@jwt_required()
def get_ref_batch(reference_pk):
    req = (Stock.select(Stock.lot.distinct().alias('batch'))
           .join(Product, on=Stock.reference == Product.reference)
           .where(Product.pk == reference_pk))

    return {'list': [
        {
            'batch': item.batch
        } for item in req
    ]}, HTTP_200_OK


@reference_blueprint.route('/<string:reference_pk>/cips', methods=['GET'])
@jwt_required()
def get_ref_cips(reference_pk):
    req = (Cip.select(Cip.cip, Cip.ucd)
           .join(Ucd, on=Ucd.ucd == Cip.ucd)
           .join(Product, on=Ucd.reference == Product.reference)
           .where((Product.pk == reference_pk))
           .group_by(Cip.cip, Cip.ucd))

    return {'list': [
        {

            'cip': item.cip,
            'ucd': item.ucd
        } for item in req
    ]}, HTTP_200_OK


@reference_blueprint.route('/<string:reference_pk>/print', methods=['PUT'])
@jwt_required()
def print_labels(reference_pk):

    # data = json.loads(request.data)

    # Data structure :
    # quantity
    # ucd
    # batch
    # expirationDate
    # cip

    return {}, HTTP_204_NO_CONTENT
