import logging

from flask import Blueprint
from flask_jwt_extended import jwt_required
from median.models import Profil

profils_blueprint = Blueprint('profils', __name__)

logger = logging.getLogger('median')


@profils_blueprint.route('', methods=['GET'])
@jwt_required()
def get_all():
    logger.info("Récupérer les profils utilisateurs")
    # TODO: Utiliser f_resrc qui est utilisé pour lister les droits, au lieu du distinct qui peut en oublier
    paged_profils = (Profil.select(Profil.profil).distinct())

    return ([{
        'profil': i.profil
    } for i in paged_profils])
