import logging

from common.status import HTTP_204_NO_CONTENT, HTTP_400_BAD_REQUEST
from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from median.models import Ucd, Product

from ressources.blueprint.config.config_service import get_drug_standard, DrugStandard

gtin_cip_blueprint = Blueprint('gtin_cip', __name__)

logger = logging.getLogger('median')


@gtin_cip_blueprint.route('<string:ref_pk>', methods=['DELETE'])
@jwt_required()
def delete(ref_pk):
    args = request.args
    _ucd = args['ucd']

    p = Product.select().where(Product.pk == ref_pk).get()
    ref = p.reference
    logger.info('Suppression d\'un UCD, ref: "%s", UCD: "%s"' % (ref, _ucd))

    try:
        Ucd.delete().where((Ucd.reference == ref) & (Ucd.ucd == _ucd)).execute()
        logger.info('Suppression réussie d\'un UCD, ref: "%s", UCD: "%s"' % (ref, _ucd))
        return 'Success', HTTP_204_NO_CONTENT

    except Exception as error:
        logger.error(error.args)
        return error.args, HTTP_400_BAD_REQUEST


@gtin_cip_blueprint.route('<string:ref_pk>', methods=['POST'])
@jwt_required()
def post(ref_pk):

    logger.info('Ajout d\'un nouvel UCD...')

    args = request.json
    v_ucd = args['ucd']

    drugs_standard = get_drug_standard()

    if drugs_standard == DrugStandard.Pzn:
        if len(v_ucd) != 7 and len(v_ucd) != 8:
            return {'message': f'threshold.{drugs_standard.value}.error.length'}, HTTP_400_BAD_REQUEST
    else:
        if len(v_ucd) != 7 and len(v_ucd) != 13:
            return {'message': 'threshold.ucdcip.error.length'}, HTTP_400_BAD_REQUEST

    if not v_ucd.isdigit():
        return {'message': f'threshold.{drugs_standard.value}.error.digit'}, HTTP_400_BAD_REQUEST

    try:
        p = Product.select().where(Product.pk == ref_pk).get()
        ref = p.reference

        # regarder si on n'a pas déjà une réf associée à cet UCD
        existing_ucd_count = (
            Ucd.select(Ucd.reference)
            .where((Ucd.ucd == v_ucd))
        )

        if existing_ucd_count.count() > 0:
            return {'message': f'threshold.{drugs_standard.value}.association.error.exist'}, HTTP_400_BAD_REQUEST

        Ucd.create(reference=ref, ucd=v_ucd)

        logger.info('Ajout d\'un nouvel UCD... REUSSI')
        return 'Success', HTTP_204_NO_CONTENT

    except Exception as error:
        logger.error(error.args)
        return {'message': error.args}, HTTP_400_BAD_REQUEST
