from enum import Enum

from median.views import RawConfig


class DrugStandard(Enum):
    Pzn = 'pzn'
    Cip = 'cip'


def get_drug_standard():
    config = RawConfig().read("k_drug_country")

    if config is not None and config.value == 'de':
        return DrugStandard.Pzn
    else:
        return DrugStandard.Cip
