from common.status import HTTP_200_OK
from flask import Blueprint
from flask_jwt_extended import jwt_required
from median.views import RawConfig

from ressources.blueprint.config.config_service import DrugStandard

config_blueprint = Blueprint('config', __name__)


@config_blueprint.route('drugs', methods=['GET'])
@jwt_required()
def get_drug_config():
    config = RawConfig().read("k_drug_country")

    obj = None

    if config is not None and config.value == 'de':
        obj = {
            "country": "de",
            "standard": DrugStandard.Pzn.value,
            "ucd_name": "PZN8",
            "cip_name": "PZN13",
            "cip_standard": "gs1"
        }

    return {
        'data': obj
    }, HTTP_200_OK
