import logging

from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from median.models import Adresse, Magasin

from median.views import Emplacement
from median.constant import EcoType

available_adresses_blueprint = Blueprint('available_adresses_blueprint', __name__)

logger = logging.getLogger('median')


@available_adresses_blueprint.route('', methods=['GET'])
@jwt_required()
def get_all():
    # get args
    args = request.args
    _ref = args['reference']
    _adr = args['origin_adresse']
    _mag = args['magasin']
    _format = args['format']

    _creation = True if args['creation'] == 'true' else False

    try:
        # get format for origin_address
        if _adr != '-':
            _format = Adresse.get(Adresse.adresse == _padAddressField(_adr)).format
        else:
            _format = _format.replace('__', ' ')

        equipment = Magasin.select(Magasin.eco_type).where(Magasin.mag == _mag).get()

        # get available addresses
        if equipment.eco_type != EcoType.Externe.value:
            _available_adr = Emplacement.libre(_ref, _mag, _format, _creation)
        else:
            _available_adr = get_free_external_locations(_mag)
        logger.info('Lines : %s.' % len(_available_adr))

    except Exception as error:
        logger.error('Exception levée en cherchant les emplacements libres. Variables => '
                     'ref: "%s", magasin: "%s", format: "%s", creation: "%s"' % (_ref, _mag, _format, _creation))
        return {'message': error.args}, 503

    return _available_adr


def get_free_external_locations(mag):
    addresses = Adresse.select(Adresse.adresse, Adresse.pk).where(Adresse.magasin == mag)

    return [{
        'id': item.pk,
        'adresse': item.adresse
    } for item in addresses]


def _padAddressField(adr):
    _adr_items = adr.split('.')

    _o = []
    for a in _adr_items:
        _o.append(a.rjust(3))

    return '.'.join(_o)
