from datetime import datetime
from io import BytesIO

import xlsxwriter
from pathlib import Path
import os
import logging

logger = logging.getLogger('median.webserver')


# deprecated => "Use generate_memory_excel_file instead")
def generate_excel_file(name, headers, items, transform_function, custom_lines=[]):
    writer = generate_excel_writer(name=name)
    add_excel_worksheet(headers, items, transform_function, writer, None, custom_lines)
    close_excel_writer(writer=writer)


def generate_memory_excel_file(headers, items, transform_function, custom_lines=[]):
    output = BytesIO()
    writer = generate_memory_excel_writer(output=output)
    add_excel_worksheet(headers, items, transform_function, writer, None, custom_lines)
    close_excel_writer(writer=writer)
    output.seek(0)
    return output


def generate_memory_excel_writer(output):
    writer = xlsxwriter.Workbook(output, {'constant_memory': True})
    return writer


def generate_excel_writer(name):
    Path("tmp_export").mkdir(parents=True, exist_ok=True)

    writer = xlsxwriter.Workbook(name, {'constant_memory': True})
    logger.info(os.sep.join([os.getcwd(), "tmp_export", "%s.xlsx" % name]))

    return writer


def add_excel_worksheet(translations, items, transform_function, writer, work_sheet_name, custom_lines):
    format_court = writer.add_format({'num_format': 'dd/mm/yyyy'})

    worksheet = writer.add_worksheet(name=work_sheet_name)

    row = 0

    for custom_line in custom_lines:
        num_col = 0
        for custom_elt in custom_line:
            worksheet.write(row, num_col, custom_elt['label'])
            num_col += 1
            worksheet.write(row, num_col, custom_elt['value'])
            num_col += 1
        row += 1

    row += 1
    init_row = row
    for stk in items:
        col = 0
        obj = transform_function(stk)

        if row == init_row:
            col_header = 0
            for props_name in obj.keys():
                col_name = translations.get(props_name, None)
                if col_name is not None:
                    worksheet.write(row, col_header, col_name)
                col_header += 1
            row += 1

        for props_name in obj.keys():
            val = obj.get(props_name, None)

            if val is not None:

                if isinstance(val, datetime):
                    worksheet.write_datetime(row, col, val, format_court)
                else:
                    worksheet.write(row, col, val)

            col += 1

        row += 1


def close_excel_writer(writer):
    writer.close()
