import json

from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from median.models import Magasin, MagasinService, Service
from peewee import DoesNotExist, JOIN

from common.status import HTTP_200_OK

astus_ward_blueprint = Blueprint('astus_ward', __name__)


@astus_ward_blueprint.route('associated/<string:astus_pk>', methods=['GET'])
@jwt_required()
def get_associated_astus(astus_pk):
    try:
        mag = Magasin.get(pk=astus_pk)

        wards = MagasinService \
            .select(MagasinService, Service) \
            .join(Service, on=(MagasinService.dest == Service.code)) \
            .where(MagasinService.mag == mag.mag)

        list_ward = []

        for ward in wards:
            obj = {
                'pk': ward.service.pk,
                'code': ward.service.code,
                'label': ward.service.libelle}
            list_ward.append(obj)

        return {'data': list_ward
                }, 200

    except DoesNotExist:
        return {'message': 'Magasin does not exist'}, 400


@astus_ward_blueprint.route('<string:astus_pk>', methods=['GET'])
@jwt_required()
def get_astus(astus_pk):
    try:
        mag = Magasin.get(pk=astus_pk)

        wards = Service \
            .select(MagasinService, Service) \
            .join(MagasinService, JOIN.LEFT_OUTER,
                  on=((MagasinService.dest == Service.code) & (MagasinService.mag == mag.mag))) \
            .where(MagasinService.pk.is_null())

        list_ward = []

        for ward in wards:
            obj = {
                'pk': ward.pk,
                'code': ward.code,
                'label': ward.libelle}
            list_ward.append(obj)

        return {'data': list_ward
                }, 200

    except DoesNotExist:
        return {'message': 'Magasin does not exist'}, 400


@astus_ward_blueprint.route('<string:astus_pk>', methods=['POST'])
@jwt_required()
def add(astus_pk):
    try:
        mag = Magasin.get(pk=astus_pk)
        data = json.loads(request.data)
        data_source = []
        for ward in data:
            obj = {
                'mag': mag.mag,
                'dest': ward['code']
            }
            data_source.append(obj)

        MagasinService.insert_many(data_source).execute()
        return {}, HTTP_200_OK

    except DoesNotExist:
        return {'message': 'Magasin does not exist'}, 400


@astus_ward_blueprint.route('<string:astus_pk>', methods=['DELETE'])
@jwt_required()
def delete(astus_pk):
    try:
        mag = Magasin.get(pk=astus_pk)
        data = json.loads(request.data)
        data_source = []
        for ward in data:
            data_source.append(ward['code'])

        MagasinService\
            .delete()\
            .where(
                (MagasinService.mag == mag.mag) &
                MagasinService.dest.in_(data_source))\
            .execute()
        return {}, HTTP_200_OK

    except DoesNotExist:
        return {'message': 'Magasin does not exist'}, 400
