import json
import os
from pathlib import Path
from xml.dom import minidom

FRONT_DIRECTORY = os.environ.get('FRONT_DIRECTORY', '')
RESOURCE_DIRECTION = os.environ.get('RESOURCE_DIRECTION', '')

DEFAULT_LANGUAGE = 'en_GB'


def generate_resources_files():
    dest = RESOURCE_DIRECTION
    base = FRONT_DIRECTORY

    generate_resource(dest, base)


def generate_resource(dest, base):
    directories = next(os.walk(base))[1]
    for d in directories:
        if os.path.exists(f'{base}\\{d}'):
            if d == 'lang':
                create_lang_resource(f'{dest}\\{d}', f'{base}\\{d}')
            else:
                generate_resource(f'{dest}\\{d}', f'{base}\\{d}')


def create_lang_resource(dest, directory):
    directories = next(os.walk(directory))[1]
    json_main = None
    if any(filter(lambda x: x == DEFAULT_LANGUAGE, directories)):
        json_main = create_main_resource(dest, f'{directory}\\{DEFAULT_LANGUAGE}', )

    for d in directories:
        create_resource(f'{dest}', f'{directory}\\{d}', lang=d, json_main=json_main)


def create_main_resource(dest, directory):
    for file in os.listdir(directory):
        f = open(f'{directory}\\{file}', "r")
        content = f.read()
        content = content.replace('export default', '')
        print(f'{directory}\\{file}')
        json_object = json.loads(content)
        pot_filename = 'res.resx'
        Path(dest).mkdir(parents=True, exist_ok=True)

        generate_resource_file(json_main=json_object, dest_file=f'{dest}\\{pot_filename}', lang=None)
        return json_object


def create_resource(dest, directory, lang, json_main):
    for file in os.listdir(directory):
        f = open(f'{directory}\\{file}', "r")
        content = f.read()
        content = content.replace('export default', '')
        print(lang)
        dest_filename = f'res.{lang}.resx'
        json_object = json.loads(content)

        Path(dest).mkdir(parents=True, exist_ok=True)
        o = open(f'{dest}\\{dest_filename}', 'w')
        o.close()

        generate_resource_file(json_main=json_main, dest_file=f'{dest}\\{dest_filename}', lang=lang,
                               json_data=json_object)


def generate_resource_file(json_main, dest_file, lang, json_data=None):
    root = minidom.Document()

    xml = root.createElement('root')
    root.appendChild(xml)

    for data in json_main:
        if lang is None:
            json_value = json_main[data]
        else:
            json_value = json_data[data] if json_data is not None and (data in json_data) else ''

        child = root.createElement('data')
        child.setAttribute('name', data)
        value = root.createElement('value')
        value.appendChild(root.createTextNode(json_value))
        child.appendChild(value)

        if lang is None:
            comment = root.createElement('comment')
            comment.appendChild(root.createTextNode(json_value))
            child.appendChild(comment)

        xml.appendChild(child)

    xml_str = root.toprettyxml(indent="\t")

    with open(dest_file, "w") as f:
        f.write(xml_str)


# resource -> translation #
def generate_translations_files():
    base = RESOURCE_DIRECTION
    dest = FRONT_DIRECTORY
    generate_translation(dest=dest, base=base)


def generate_translation(dest, base):
    directories = next(os.walk(base))[1]
    for d in directories:
        if os.path.exists(f'{base}\\{d}'):
            if d == 'lang':
                create_translation(f'{dest}\\{d}', f'{base}\\{d}')
            else:
                generate_translation(f'{dest}\\{d}', f'{base}\\{d}')


def create_translation(dest, directory):
    for file in os.listdir(directory):

        lang = file.split('.')[1]
        if lang != 'resx':
            dest_filename = f'terms_{lang}.js'

            Path(f'{dest}\\{lang}').mkdir(parents=True, exist_ok=True)
            o = open(f'{dest}\\{lang}\\{dest_filename}', 'w')
            o.close()

            generate_translation_file(dest_file=f'{dest}\\{lang}\\{dest_filename}',
                                      source_file=f'{directory}\\{file}')


def generate_translation_file(dest_file, source_file):
    xml = minidom.parse(source_file)

    datas = xml.getElementsByTagName("data")
    json_data = {}
    for data in datas:
        key = data.getAttribute("name")
        node_value = data.getElementsByTagName("value")[0].firstChild

        if node_value is not None:
            value = node_value.data
            json_data.update({key: value})

    r = json.dumps(json_data, indent=4, ensure_ascii=False)

    with open(dest_file, "w", encoding="utf-8") as f:
        f.write('export default')
        f.write(r)


# Add new language
def generate_translations_lang(code):
    dest = FRONT_DIRECTORY

    # create file
    generate_new_translation(dest=dest, code=code)

    # Add import
    add_import(dest=dest, code=code)


def add_import(dest, code):
    (dirpath, directories, filenames) = next(os.walk(dest))
    for d in filenames:
        if os.path.isfile(f'{dest}\\{d}') and search_str(f'{dest}\\{d}', 'const{t}=useI18n({messages:{', replace=True):
            content = ""

            dirpath.replace(FRONT_DIRECTORY, '')

            with open(f'{dest}\\{d}', 'r') as vueFile:
                content = vueFile.read()
            # import
            index = content.index('import enGB from ')
            length = len('import enGB from ')
            index_end = content.index('/lang/en_GB/terms_en_GB.js')
            root = content[(index+length):index_end]
            import_string = f'import {code.replace("_", "")} from {root}/lang/{code}/terms_{code}.js"'

            if not search_str(f'{dest}\\{d}', import_string, replace=False):
                content = content[:index] + f'{import_string}\n' + content[index:]

            index_msg = content.index('en_GB: enGB')
            msg_string = f'{code}: {code.replace("_", "")}'
            if not search_str(f'{dest}\\{d}', msg_string, replace=False):
                content = content[:index_msg] + f'{msg_string},\n' + content[index_msg:]

            with open(f'{dest}\\{d}', 'w') as vueFile:
                vueFile.write(content)

    for d in directories:
        if os.path.exists(f'{dest}\\{d}'):
            add_import(f'{dest}\\{d}', code)


def search_str(file_path, word, replace):
    with open(file_path, 'r') as file:
        # read all content of a file
        content = file.read()
        # check if string present in a file
        if word in ((content.replace(' ', '').replace('\n', '')) if replace else content):
            return True
        else:
            return False


def generate_new_translation(dest, code):
    directories = next(os.walk(dest))[1]
    for d in directories:
        if os.path.exists(f'{dest}\\{d}'):
            if d == 'lang':
                create_new_translation(f'{dest}\\{d}', code)
            else:
                generate_new_translation(f'{dest}\\{d}', code)


def create_new_translation(dest, lang):
    dest_filename = f'terms_{lang}.js'

    Path(f'{dest}\\{lang}').mkdir(parents=True, exist_ok=True)
    if not os.path.isfile(f'{dest}\\{lang}\\{dest_filename}'):
        with open(f'{dest}\\{lang}\\{dest_filename}', "w", encoding="utf-8") as f:
            f.write('export default')
            f.write('{\n')
            f.write('}')
