from common.exception import RiedlPrinterException
from median.views import RawConfig


def printer_riedl_configuration(riedl: str):
    """
    Retrieve default printer associate to the RIEDL

    :param riedl: Riedl code
    :returns: a tuple with printer address, name and label offset
    """
    try:
        cfg = RawConfig(riedl)
        printer_number = cfg.read('k_rdl_printer').value
    except Exception:
        printer_number = 1

    try:
        printer_key = "k_rdl_printer_adr_%i" % printer_number
        name_key = "k_rdl_printer_name_%i" % printer_number
        offset_key = "k_rdl_printer_offset_%i" % printer_number
        template_key = "k_rdl_tk_template_%i" % printer_number
        cfg = RawConfig('TOUS')

        pr_addr = cfg.read(printer_key).value
        pr_name = cfg.read(name_key).value
        pr_offset = cfg.read(offset_key).value
        pr_template = cfg.read(template_key).value
    except Exception:
        raise RiedlPrinterException("Error to retrieve printer %i configuration!" % printer_number)
    return (pr_addr, pr_name, pr_offset, pr_template)
