import logging

from datetime import datetime
from common.models import WebLogActions


logger = logging.getLogger('median.log')


def log_riedl(username: str, action: str, message: str):
    """
    Add new log for Riedl

    :param username: User made the action to log
    :param action:
    :param message: message to log
    """
    logger.info('RIEDL[%s](%s)): %s' % (action, username, message))
    wlog = WebLogActions()
    wlog.chrono = datetime.now()
    wlog.username = username
    wlog.equipement_type = 'RIEDL'
    wlog.action = action
    wlog.message = message
    wlog.save()
