from peewee import DoesNotExist
from median.models import ListeModel, Service

zpl_riedl_container = """^XA
^LS{label_shift}^FS
^FS^FS
^PON^FS
^KL3^FS

^FO50,20^GB1180,720,4,B,1^FS

^FO326,96^A0N,62,46^FDCode UF: {ward_code}^FS
^FO326,226^A0N,58,38^FDService: {ward_label}^FS

^FO350,400^BY3
^BCN,100,Y,N,N
^FD{container_code}^FS

^FO80,230^A0B,36,36^FDMEDIAN / DEENOVA^FS

^PQ1^FS
^XZ"""


def compose_container_label(list_obj: ListeModel, label_shift: int = 0, label_top: int = 0) -> str:
    """
    Generate a container label and return the ZPL string to send
    to the printer
    """
    label_datas = {
        'label_shift': label_shift,
        'label_top': label_top,
        'container_code': list_obj.id_plateau,
        'ward_code': list_obj.service,
        'ward_label': '-',
    }
    try:
        serv = Service.get(code=list_obj.service, type_dest='SERVICE')
        label_datas['ward_label'] = serv.libelle
    except DoesNotExist:
        label_datas['ward_label'] = 'Inconnu'

    return zpl_riedl_container.format(**label_datas)
