import click
import requests
import json
import bcrypt
import datetime
from urllib.parse import urljoin

from median.models import User
from common.util import logger
from peewee import DoesNotExist
from median.database import crypte
from median.views import RawConfig

headers = {'Content-Type': 'application/x-www-form-urlencoded'}


@click.command("sync-users")
def synchronize_users():
    """Synchronize user from the monitoring"""
    print("Start to synchronize user")
    logger.info("Begin to synchronize user")
    # Retrieve token from the database
    cfg_token = RawConfig().read("k_eco_monitoring_token")
    cfg_url = RawConfig().read("k_eco_monitoring")

    try:
        monit_url = urljoin(cfg_url.value, "sync-user.php")
        response = requests.post(monit_url, data={"token": cfg_token.value}, headers=headers)
        if response.status_code == 200:
            content = json.loads(response.content)
            # We retrieve a list
            for line in content:
                try:
                    usr = User.get(email=line["adresse_mail"])
                    print("User %s %s exists" % (line["prenom"], line["nom"]))
                    logger.info("User %s %s exists" % (line["prenom"], line["nom"]))

                except DoesNotExist:
                    print("User %s %s to create" % (line["prenom"], line["nom"]))
                    logger.info("User %s %s to create" % (line["prenom"], line["nom"]))
                    usr = User()
                    usr.username = "%s %s" % (line["prenom"], line["nom"])
                    usr.email = line["adresse_mail"]
                    usr.password = crypte(line["code_pin"])
                    usr.passwordWeb = bcrypt.hashpw(
                        line["code_pin"].encode('UTF_8'), bcrypt.gensalt())
                    usr.isTemporary = 0
                    usr.profil = "ECO-DEX"
                    usr.retry = 5
                    usr.date_creation = datetime.datetime.now()
                    usr.import_flag = -1

                # In all case re rewrite fields
                usr.description = line["titre"][:20]
                usr.lang = line.get("langue", "fr_FR")
                usr.service = "DEENOVA"
                usr.login = line["login"]
                usr.isEnabled = int(line["actif"])
                if line["actif"] == "0":
                    usr.password = "----"
                    usr.passwordWeb = "----"
                    usr.isEnabled = 0
                    print("  -> disable")
                    logger.warning("- user %s is disable !" % usr.username)
                usr.save()
        else:
            print("Monitoring not available: HTTP Status %s" % response.status_code)
            logger.error("Monitoring not available: HTTP Status %s" % response.status_code)
    except requests.exceptions.ConnectionError:
        print("Connect to %s failed !!!" % monit_url)
        logger.error("Connection error to: %s" % monit_url)

    # Disable ecopilote user, because GDPR/RGPD imposed to have a named users
    try:
        usr = User.get(username="ecopilote")
        if usr.password != "----":
            logger.warning("ecopilote user is enable, we disable it")
            usr.password = "----"
            usr.passwordWeb = "----"
        else:
            logger.info("ecopilote user already disable")
        usr.description = "Desactivé RGPD"
        usr.lang = "en_US"
        usr.retry = 0
        usr.isEnabled = 0
        usr.save()
        print("ecopilote user found and disable")
    except DoesNotExist:
        print("ecopilote user not found!!")
        logger.warning("ecopilote user not found!!")

    # Old Median Client, disable autologin (GDPR/RGPD conform)
    # https://linc.cnil.fr/fr/securiser-les-donnees-de-sante-dans-les-applications-en-reseau-0
    try:
        # Autologin
        val = RawConfig().read("k_do_login")
        val.value = "1"
        val.save()
        # Timeout
        val = RawConfig().read("k_login_tmout")
        val.value = "15"  # 15 minutes
        val.save()
    except Exception:
        logger.error("Error when we try to disable autologin")

    print("End to synchronize user")
