from peewee import (
    AutoField, CharField, IntegerField,
    DateTimeField, TextField, FloatField
)
from peewee import SQL
from ..base import BaseModel, InnodbModel
from ..database import TinyIntegerField


class LogAstus(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    mag = CharField(
        column_name='x_mag', max_length=3, null=True,
        constraints=[SQL("DEFAULT ''")])
    code_erreur = IntegerField(
        column_name='x_code_erreur')
    utilisateur = CharField(
        column_name='x_utilisateur', max_length=50, null=True,
        constraints=[SQL("DEFAULT ''")])
    adresse = CharField(
        column_name='x_adresse', max_length=19, null=True,
        constraints=[SQL("DEFAULT ''")])
    ref_produit = CharField(
        column_name='x_ref_produit', max_length=35, null=True,
        constraints=[SQL("DEFAULT ''")])
    lot_produit = CharField(
        column_name='x_lot_produit', max_length=20, null=True,
        constraints=[SQL("DEFAULT ''")])
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")])
    descriptif = TextField(
        column_name='x_descriptif', null=True)
    message = CharField(
        column_name='x_message', max_length=300,
        constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_log_astus'
        indexes = (
            (('x_mag',), False),
            (('x_chrono',), False),
            (('x_code_erreur',), False),
        )


class MessageAstus(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    niveau = IntegerField(
        column_name='x_niveau', constraints=[SQL("DEFAULT 0")])
    message = CharField(
        column_name='x_message', max_length=200,
        constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_message_astus'
        indexes = (
            (('x_niveau',), False),
        )


class LogInfo(BaseModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")])
    poste = CharField(
        column_name='x_poste', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    section = CharField(
        column_name='x_section', null=True, max_length=16, constraints=[SQL("DEFAULT ''")], default='')
    log = TextField(
        column_name='x_log')

    class Meta:
        table_name = 'f_log_info'
        indexes = (
            (('x_poste',), False),
            (('x_poste', 'x_section'), False),
        )


class LogDefaut(InnodbModel):
    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    poste = CharField(
        column_name='x_module', null=False, max_length=35)
    num_defaut = CharField(
        column_name='x_num_defaut', null=True, max_length=10)
    valeur = TinyIntegerField(
        column_name='x_valeur', constraints=[SQL("DEFAULT 0")], default=0)
    message = CharField(
        column_name='x_message', null=True, max_length=100)

    class Meta:
        table_name = 'f_log_defaut'
        indexes = (
            (('x_module',), False),
            (('x_chrono',), False),
        )


class MagLogDefault(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', constraints=[SQL("DEFAULT CURRENT_TIMESTAMP")])
    poste = CharField(
        column_name='x_poste', null=True, max_length=20)
    num_defaut = CharField(
        column_name='x_num_defaut', null=True, max_length=10)
    message = CharField(
        column_name='x_message', null=False, max_length=100, default='')

    class Meta:
        table_name = 'f_mag_log_defaut'
        indexes = (
            (('x_poste',), False),
        )


class DefDefaut(BaseModel):
    pk = AutoField(column_name='x_pk', primary_key=True)
    num_defaut = CharField(column_name='x_num_defaut', max_length=4)
    niveau = IntegerField(column_name='x_niveau')
    defaut = IntegerField(column_name='x_defaut')
    type_machine = CharField(
        column_name="x_type_machine", max_length=20, constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_def_defaut'
        indexes = (
            (('x_type_machine',), False),
        )


class LogEchangeRiedl(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True)
    poste = CharField(
        column_name='x_poste', null=True, max_length=20)
    type = CharField(
        column_name='x_type', null=True, max_length=3)
    reference = CharField(
        column_name='x_ref', max_length=35)
    qte = FloatField(
        column_name='x_qte', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    lot = CharField(
        column_name='x_lot', null=True, max_length=20, default="")
    tperemp = DateTimeField(
        column_name='x_tperemp', null=True)
    serial = CharField(
        column_name='x_serial', null=True, max_length=40)
    demande = CharField(
        column_name='x_demande', null=True, max_length=40)
    priority = IntegerField(
        column_name='x_priority', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    bouche = IntegerField(
        column_name='x_bouche', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    comment = TextField(
        column_name='x_comment', null=True)
    livraison = CharField(
        column_name='x_livraison', null=True, max_length=40)
    gtin = CharField(
        column_name='x_cip', null=True, max_length=20)

    class Meta:
        table_name = 'f_log_echange_riedl'
        indexes = (
            (('x_chrono',), False),
            (('x_poste',), False),
            (('x_ref',), False),
            (('x_type',), False),
            (('x_demande',), False),
        )
