from peewee import (
    AutoField,
    CharField
)
from peewee import SQL

from ..base import BaseModel


class Label(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    code = CharField(
        column_name='x_code', constraints=[SQL("DEFAULT ''")])
    libelle = CharField(
        column_name='x_libelle', constraints=[SQL("DEFAULT ''")])
    libelle_0 = CharField(
        column_name='x_libelle_0', constraints=[SQL("DEFAULT ''")])
    libelle_1 = CharField(
        column_name='x_libelle_1', constraints=[SQL("DEFAULT ''")])

    class Meta:
        table_name = 'f_libelles'
        indexes = (
            (('x_code',), False),
            (('x_libelle_0',), False),
            (('x_libelle_1',), False),
        )
