from peewee import (
    AutoField,
    CharField,
    IntegerField,
    FloatField,
    DateTimeField,
    BooleanField,
)
from peewee import SQL
from ..base import BaseModel


class Gpao(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono', null=True, constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    poste = CharField(
        column_name='x_poste', null=True, max_length=20, constraints=[SQL("DEFAULT ''")])
    etat = CharField(
        column_name='x_etat', null=True, max_length=1, constraints=[SQL("DEFAULT ''")])
    ref = CharField(
        column_name='x_ref', null=True, max_length=35, constraints=[SQL("DEFAULT ''")])
    qte = FloatField(
        column_name='x_qte', null=True, constraints=[SQL("DEFAULT 0.000")])
    admin = CharField(
       column_name='x_admin', null=True, max_length=10, constraints=[SQL("DEFAULT ''")])
    lot = CharField(
        column_name='x_lot', null=True, max_length=20, constraints=[SQL("DEFAULT ''")])
    qte_avant = FloatField(
        column_name='x_qte_avant', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    qte_apres = FloatField(
        column_name='x_qte_apres', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    type_mvt = CharField(
        column_name='x_type_mvt', null=True, max_length=1, constraints=[SQL("DEFAULT ''")], default='-')
    liste = CharField(
       column_name='x_liste', null=True, max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    dest = CharField(
        column_name='x_dest', null=True, max_length=30, constraints=[SQL("DEFAULT ''")], default='')
    user = CharField(
        column_name='x_user', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    item = CharField(
        column_name='x_item', null=True, max_length=40, constraints=[SQL("DEFAULT ''")], default='')
    indice = IntegerField(
       column_name='x_indice', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    sequence = CharField(
        column_name='x_sequence', null=True, max_length=25, constraints=[SQL("DEFAULT ''")], default='')
    magasin = CharField(
        column_name='x_num_mag', null=True, max_length=5, constraints=[SQL("DEFAULT ''")], default='')
    interface = CharField(
        column_name='x_interface', constraints=[SQL("DEFAULT ''")])
    demandeur = CharField(
        column_name='x_demandeur', null=True, max_length=1, constraints=[SQL("DEFAULT ''")], default='')
    info = CharField(
        column_name='x_info', null=True, max_length=80, constraints=[SQL("DEFAULT ''")], default=80)
    exporte = BooleanField(
        column_name='x_exporte', null=True, constraints=[SQL("DEFAULT 0")])
    date_demande = CharField(
        column_name='x_date_dem', null=True, max_length=8, constraints=[SQL("DEFAULT ''")], default='')
    heure_demande = CharField(
        column_name='x_heure_dem', null=True, max_length=8, constraints=[SQL("DEFAULT ''")], default='')
    num_demande = FloatField(
        column_name='x_num_dem', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    ucd = CharField(
         column_name='x_ucd', max_length=20, constraints=[SQL("DEFAULT ''")],
         default="")
    cip = CharField(
        column_name='x_cip',  max_length=20, constraints=[SQL("DEFAULT ''")],
        default="")
    desig = CharField(
        column_name='x_desig', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    qte_dem = FloatField(
        column_name='x_qte_dem', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    qte_disp = FloatField(
        column_name='x_qte_disp', null=True, constraints=[SQL("DEFAULT 0.000")], default=0.0)
    unite = CharField(
        column_name='x_unite', null=True, max_length=5, constraints=[SQL("DEFAULT ''")], default='')
    lib_unite = CharField(
        column_name='x_lib_unite', null=True, max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    typ_dem = CharField(
        column_name='x_typ_dem', null=True, max_length=2, constraints=[SQL("DEFAULT ''")], default='')
    id_pilulier = CharField(
        column_name='x_id_pilulier', max_length=40, constraints=[SQL("DEFAULT ''")], default='')
    case = IntegerField(
        column_name='x_case', constraints=[SQL("DEFAULT 0")], default=0)
    solde = IntegerField(
        column_name='x_solde', constraints=[SQL("DEFAULT 0")], default=0)
    tperemp = DateTimeField(
        column_name='x_tperemp', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    item_wms = IntegerField(
        column_name='x_item_wms', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    tenvoi = DateTimeField(
        column_name='x_tenvoi', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    serial = CharField(
        column_name='x_serial', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    # type_mvt_bte = CharField(
    #     column_name='xx_type_mvt_bte', constraints=[SQL("DEFAULT ''")])
    contenant = CharField(
        column_name='x_contenant', max_length=20, constraints=[SQL("DEFAULT ''")], default='')
    tentree = DateTimeField(
        column_name='x_tentree', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    fraction = IntegerField(
        column_name='x_fraction', constraints=[SQL("DEFAULT 100")], default=100)
    pk_item = IntegerField(
        column_name='x_pk_item', constraints=[SQL("DEFAULT 0")], default=0)
    ipp = CharField(
        column_name='x_ipp', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    sejour = CharField(
        column_name='x_sejour', max_length=35, constraints=[SQL("DEFAULT ''")], default='')
    id_zone = IntegerField(
        column_name='x_id_zone', null=True, constraints=[SQL("DEFAULT 1")], default=1)
    id_robot = IntegerField(
        column_name='x_id_robot', null=True, constraints=[SQL("DEFAULT 1")], default=1)

    class Meta:
        table_name = 'f_gpao'
        indexes = (
            (('x_chrono',), False),
            (('x_etat',), False),
            (('x_item_wms',), False),
            (('x_solde',), False),
            (('x_type_mvt',), False),
        )
