import datetime

from median.constant import TypeServiListe, PatientGlobal, EtatListe, TypeListe
from median.models import Config, FListe
from median.views import Seuil


def get_cancel_or_replace():
    n = Config.get(poste='TOUS', cle='cfg', propriete='k_annule_remplace')

    return n.value


def riedl_replenish(lines, liste, service, mag, gpao, username):
    if len(lines) > 0:

        counter = (FListe
                   .select(FListe.pk)
                   .where(FListe.liste.startswith(liste)).count())
        liste = f'{liste}{counter+1}'
        FListe.create(
            liste=liste, date_creation=datetime.datetime.now(),
            etat=EtatListe.Vierge.value,
            mode=TypeListe.Input.value,
            fusion='RANGEMENT',
            zone_deb='RIEDL',
            num_ipp=PatientGlobal.Ipp.value,
            num_sej=PatientGlobal.Sejour.value,
            service=service,
            date_modification=datetime.datetime.now(),
            zone_fin=mag.type_mag,
            username=username,
            type_servi=TypeServiListe.GlobaleBoite.value,
            id_servi=2,
            nb_item=len(lines)
        )

        # Création des items
        item = 1
        for r in lines:
            Seuil().reappro_item(liste, item, r["ref"], r["fraction"], r["quantite"],
                                 mag.type_mag, service, mag.id_zone, mag.id_robot, gpao)
            item = item + 1

    # Création f_gpao
    elif gpao:
        Seuil().creer_gpao(mag.id_zone)
