import logging
from median.constant import EcoType, EtatAdresse, EquipmentType, \
    PickingMachineType
from median.models import Adresse, EquipmentUnitStock

from ressources.equipments.store_utils import init_equipment, getColumns_version, add_poste_espace, remove_equipment

from ressources.equipments.acced.acced_v2 import generate_v2
from ressources.equipments.acced.acced_v3 import generate_v3
from ressources.equipments.store_utils import create_equipment_topo

logger = logging.getLogger("median.equipment")


def generate_acced(data):
    type = data['type']
    version = data['version']
    if (type == EquipmentType.ACCED.value and
        (version == PickingMachineType.Acced_Boite_Pass.value or
         version == PickingMachineType.Acced_Dose_Unit.value)):

        columns_version = getColumns_version(data['version'])

        depths = int(data.get('PROFONDEUR', 2))

        equipment = init_equipment(data)
        equipment.eco_type = EcoType.Cueillette.value
        if version == PickingMachineType.Acced_Boite_Pass.value:
            equipment.nb_dim = 3
            equipment.lib_2 = 'EMPLACEMENT'
            equipment.dim_2 = 0
            equipment.lib_3 = 'PROFONDEUR'
            equipment.dim_3 = depths
            equipment.save()
        else:
            equipment.nb_dim = 5
            equipment.lib_2 = 'TYPE'
            equipment.dim_2 = 0
            equipment.lib_3 = 'LIGNE'
            equipment.dim_3 = 0
            equipment.lib_3 = 'COLONNE'
            equipment.dim_3 = 0
            equipment.lib_3 = 'PROFONDEUR'
            equipment.dim_3 = depths
            equipment.save()

        create_equipment_topo(equipment=equipment, numversion=version)

        try:
            for column in columns_version:
                unit_stock = column.catalogunitstock
                for line in range(column.cataloglines.start_line, column.cataloglines.end_line + 1):
                    for col in range(column.catalogcolumns.start_column, column.catalogcolumns.end_Column + 1):
                        if version == PickingMachineType.Acced_Boite_Pass.value:
                            for d in range(depths):
                                depth = '1' if d == 0 else '3'
                                offset = (unit_stock.order * unit_stock.total_line * unit_stock.total_colonne)
                                location = offset + line * unit_stock.total_colonne + (col + 1)
                                add_acced_adresse(equipment=equipment,
                                                  address_label=f'{equipment.mag}'
                                                                f'.{"{: >3}".format(str(location))}'
                                                                f'.{"{: >3}".format(str(depth))}',
                                                  container_type=column.catalogcolumns.container_type)

                        elif version == PickingMachineType.Acced_Dose_Unit.ACCED_V3.value:
                            if column.catalogcolumns.container_type == 'BOITE PASS':
                                for d in range(2):
                                    depth = '1' if d == 0 else '3'
                                    offset = unit_stock.total_colonne * unit_stock.order
                                    add_acced_adresse(equipment=equipment,
                                                      address_label=f'{equipment.mag}.'
                                                                    f' BP.'
                                                                    f'{"{: >3}".format(str(offset + col + 1))}.'
                                                                    f'{"{: >3}".format(str(line + 1))}.'
                                                                    f'{"{: >3}".format(str(depth))}',
                                                      container_type=column.catalogcolumns.container_type)
                            elif column.catalogcolumns.container_type.startswith('TIROIR'):
                                drawer_depths = 0
                                if column.catalogcolumns.container_type == 'TIROIR 1/3':
                                    drawer_depths = 6
                                elif column.catalogcolumns.container_type == 'TIROIR 1/4':
                                    drawer_depths = 8
                                if column.catalogcolumns.container_type == 'TIROIR 1/5':
                                    drawer_depths = 10
                                add_acced_drawer(equipment=equipment, column=column, depths=drawer_depths,
                                                 order=unit_stock.order + 1,
                                                 line=unit_stock.total_line - line)

            add_poste_espace(equipment)

        except Exception as e:
            logger.error(str(e))
            remove_equipment(equipment)

    return equipment


def add_acced_drawer(equipment, column, depths, order, line):
    for d in range(depths):
        add_acced_adresse(equipment=equipment,

                          address_label=f'{equipment.mag}.'
                                        f'TIR.'
                                        f'{"{: >3}".format(str(order))}.'
                                        f'{"{: >3}".format(str(line))}.'
                                        f'{"{: >3}".format(str(d + 1))}',
                          container_type=column.catalogcolumns.container_type)


def add_acced_adresse(equipment, container_type, address_label):
    address = Adresse()
    address.adresse = address_label
    address.magasin = equipment.mag
    address.etat = EtatAdresse.Libre.value
    address.nb_div = 1
    address.dim_x = 1
    address.dim_y = 1
    address.princ = 1
    address.format = container_type
    address.save()


def regenerate(equipment):
    equipments = EquipmentUnitStock.select(EquipmentUnitStock.pk).where(
        EquipmentUnitStock.equipment_pk == equipment.pk)

    if equipments.count() == 0 and equipment.type_machine == PickingMachineType.Acced_Dose_Unit.value:
        generate_v3(equipment)
    if equipments.count() == 0 and equipment.type_machine == PickingMachineType.Acced_Boite_Pass.value:
        generate_v2(equipment)
