from median.models import Adresse,  EquipmentUnitStock, EquipmentLines, EquipmentColumns


def topo_acced_v3(unit_stock, column, line, col):
    adresses = []
    if column.container_type == 'BOITE PASS':
        for d in range(2):
            depth = '1' if d == 0 else '3'
            offset = unit_stock.total_colonne * unit_stock.order
            adresses.append(
                f' BP.'
                f'{"{: >3}".format(str(offset + col + 1))}.'
                f'{"{: >3}".format(str(line + 1))}.'
                f'{"{: >3}".format(str(depth))}')

    elif column.container_type.startswith('TIROIR'):
        depths = 0
        if column.container_type == 'TIROIR 1/3':
            depths = 6
        elif column.container_type == 'TIROIR 1/4':
            depths = 8
        elif column.container_type == 'TIROIR 1/5':
            depths = 10

        for d in range(depths):
            adresses.append(
                f'TIR.'
                f'{"{: >3}".format(str(unit_stock.order + 1))}.'
                f'{"{: >3}".format(str(unit_stock.total_line - line))}.'
                f'{"{: >3}".format(str(d + 1))}')

    return adresses


def generate_v3(equipment):
    adresses = list(Adresse.select(Adresse).where(Adresse.magasin == equipment.mag))

    total_column_v3 = 4
    total_line_v3 = 13
    total_unit_stock = 10

    for stk in range(total_unit_stock):
        eq_stock = EquipmentUnitStock()
        eq_stock.order = stk
        eq_stock.equipment_pk = equipment.pk
        eq_stock.total_colonne = total_column_v3
        eq_stock.total_line = total_line_v3
        eq_stock.save()

        for line in range(total_line_v3):
            eq_lines = EquipmentLines()
            eq_lines.start_line = line
            eq_lines.end_line = line
            eq_lines.unit_stock_pk = eq_stock.pk
            eq_lines.save()

            col_drawers = list(filter(lambda a: a.adresse.startswith(f'{equipment.mag}'
                                                                     f'.TIR.{"{: >3}".format(str(stk + 1))}'
                                                                     f'.{"{: >3}".format(str(total_line_v3 - line))}'),
                                      adresses))
            col_bac = list(filter(lambda a: a.adresse.startswith(f'{equipment.mag}'
                                                                 f'.BAC.{"{: >3}".format(str(stk + 1))}'
                                                                 f'.{"{: >3}".format(str(total_line_v3 - line))}'),
                                  adresses))

            col_drawers = col_drawers + col_bac

            if any(col_drawers):
                eq_cols = EquipmentColumns()
                eq_cols.line_pk = eq_lines.pk
                eq_cols.start_column = 0
                eq_cols.end_Column = total_column_v3 - 1
                eq_cols.container_type = col_drawers[0].format
            else:
                eq_cols = EquipmentColumns()
                eq_cols.line_pk = eq_lines.pk
                eq_cols.start_column = 0
                eq_cols.end_Column = total_column_v3 - 1
                eq_cols.container_type = 'BOITE PASS'

            eq_cols.save()
