from median.models import EquipmentUnitStock, EquipmentLines, EquipmentColumns


def topo_acced_v2(unit_stock, line, col):
    adresses = []
    for d in range(2):
        depth = '1' if d == 0 else '3'
        offset = (unit_stock.order * unit_stock.total_line * unit_stock.total_colonne)
        location = offset + line * unit_stock.total_colonne + (col + 1)
        adresses.append(
                        f'{"{: >3}".format(str(location))}.'
                        f'{"{: >3}".format(str(depth))}')
    return adresses


def generate_v2(equipment):
    total_column_v2 = 4
    total_line_v2 = 15
    total_unit_stock = 10

    for stk in range(total_unit_stock):
        eq_stock = EquipmentUnitStock()
        eq_stock.order = stk
        eq_stock.equipment_pk = equipment.pk
        eq_stock.total_colonne = total_column_v2
        eq_stock.total_line = total_line_v2
        eq_stock.save()

        eq_lines = EquipmentLines()
        eq_lines.start_line = 0
        eq_lines.end_line = total_line_v2 - 1
        eq_lines.unit_stock_pk = eq_stock.pk
        eq_lines.save()

        eq_cols = EquipmentColumns()
        eq_cols.line_pk = eq_lines.pk
        eq_cols.start_column = 0
        eq_cols.end_Column = total_column_v2 - 1
        eq_cols.container_type = 'BOITE PASS'
        eq_cols.save()
