import logging

from security import decryptRSA
from flask import Blueprint, request, session
from common.session import login_device

devices_blueprint = Blueprint("devices", __name__)
logger = logging.getLogger("devices")


@devices_blueprint.route("/login", methods=["POST"])
def login():
    # This part will handle the session activation but coming from a device like AidePlus
    # TODO: We might have to also add something to be sure this is a known device
    data = request.get_json()
    token = data.get("token", None)
    pincode = data.get("pincode", None)
    if token:
        token = decryptRSA(token, session["privateKey"])
    if pincode:
        pincode = decryptRSA(pincode, session["privateKey"])
    return login_device(token, pincode)
