import json
import logging

from common.status import HTTP_200_OK
from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from ressources.blueprint.transfert.transfertDTO import TransfertDTO
from ressources.blueprint.transfert.transfert_service import get_all_request, get_transfert_item

transferts_blueprint = Blueprint('transferts', __name__)

logger = logging.getLogger('median')


@transferts_blueprint.route('all', methods=['POST'])
@jwt_required()
def get_all():

    data = json.loads(request.data)
    page_size = data.get('pageSize', -1)
    page_number = data.get('pageNumber', -1)

    req = get_all_request()

    if page_size > 0 and page_number >= 0:
        req = req.limit(page_size).offset(page_number * page_size)
    res = []
    for transfert in req:
        dto = TransfertDTO(pk=transfert.pk, username=transfert.username,
                           function=transfert.current_function, poste=transfert.poste,
                           nb_retry=transfert.nb_retry,
                           delete=transfert.delete, chrono=transfert.chrono)
        res.append(json.loads(dto.toJson()))

    return {'list': res}, HTTP_200_OK


@transferts_blueprint.route('count', methods=['POST'])
@jwt_required()
def get_count():
    req = get_all_request()
    return {'data': req.count()}, HTTP_200_OK


@transferts_blueprint.route('<string:pk>', methods=['GET'])
@jwt_required()
def get_transfert(pk):
    item = get_transfert_item(pk)

    return {'data': item}, HTTP_200_OK
