import operator
from enum import Enum
from functools import reduce

from median.constant import EcoType
from median.models import Profil, User, Magasin


class EQUIPMENTPROFIL(Enum):
    ASTUS = 'WEB_ASTUS'
    RIEDL = 'WEB_RIEDL'
    ACCED = 'WEB_ACCED'


def get_equipment_where_request(user_id):
    equipment_profils = [EQUIPMENTPROFIL.ACCED.value, EQUIPMENTPROFIL.ASTUS.value, EQUIPMENTPROFIL.RIEDL.value]
    user_profil = (Profil.select(Profil.ressource).join(User, on=User.profil == Profil.profil)
                   .where((User.pk == user_id) &
                          (Profil.ressource << equipment_profils) &
                          ((Profil.visu == 1) | (Profil.edit == 1))))
    expr = []
    for profil in user_profil:
        res = profil.ressource
        print(res)
        if res == EQUIPMENTPROFIL.ACCED.value:
            expr.append(Magasin.eco_type << [EcoType.Cueillette.value, EcoType.Coupe.value])
        elif res == EQUIPMENTPROFIL.ASTUS.value:
            expr.append(Magasin.eco_type << [EcoType.Astus.value])
        elif res == EQUIPMENTPROFIL.RIEDL.value:
            expr.append(Magasin.eco_type << [EcoType.Riedl.value])
    if len(expr) > 0:
        where_expr = reduce(operator.or_, expr)
    else:
        where_expr = False

    return where_expr
