import json

from flask import Blueprint, request
from flask_jwt_extended import jwt_required

from common.status import HTTP_200_OK, HTTP_204_NO_CONTENT

from common.models import WebLang

languages_blueprint = Blueprint('languages', __name__)


@languages_blueprint.route('/<string:pk>', methods=['PUT'])
@jwt_required()
def update(pk):
    data = json.loads(request.data)
    lang = WebLang.get(WebLang.pk == pk)

    lang.enable = data['isEnabled']
    lang.save()

    return {}, HTTP_204_NO_CONTENT


@languages_blueprint.route('/all', methods=['GET'])
@jwt_required()
def get_all():
    langs = WebLang.select(WebLang.code,
                           WebLang.date_format,
                           WebLang.time_format,
                           WebLang.thousands_separator,
                           WebLang.decimal_point,
                           WebLang.direction,
                           WebLang.pk,
                           WebLang.enable)

    return {'data': [{
        'code': i.code,
        'pk': i.pk,
        'enable': i.enable,
        'dateFormat': i.date_format,
        'timeFormat': i.time_format,
        'thousandsSeparator': i.thousands_separator,
        'decimalPoint': i.decimal_point,
        'direction': i.direction,
    } for i in langs]
    }, HTTP_200_OK


@languages_blueprint.route('enable', methods=['GET'])
@jwt_required()
def get_enabled():
    langs = WebLang.select().where(WebLang.enable)
    return ([{
        'code': i.code,
        'name': i.name,
        'enable': i.enable,
    } for i in langs])
