import json
import logging

from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from median.models import Poste, Espace
from median.views import Seuil as V_Seuil
from peewee import DoesNotExist

from common.rest import WebResourceException, WebResource

input_lists_blueprint = Blueprint('input_lists', __name__)

logger = logging.getLogger('median')


@input_lists_blueprint.route('<string:ref>', methods=['POST'])
@jwt_required()
def create(ref):
    logger.info("Création d'une liste d'entrée...")

    args = json.loads(request.data)
    try:
        r = WebResource()
        _fraction = r.non_zero(args['fraction'])
        _qte = r.non_zero(args['quantite'])
        _poste = r.mandatory(args['mag'], "Poste is mandatory")
    except WebResourceException as error:
        logger.error(error.args)
        return {'message': error.args}, 503

    try:
        Poste.get(poste=_poste)
    except DoesNotExist:
        logger.error('poste %s does not exists' % _poste)
        return {'message': 'poste %s does not exists' % _poste}, 503

    try:
        _esp = Espace.select(Espace.mag).where(Espace.poste == _poste)
        V_Seuil().reappro(ref, _esp[0].mag, _qte, _fraction)

    except Exception as error:
        logger.error(error.args)
        return {'message': error.args}, 503

    logger.info("""Création d'une liste d'entrée... REUSSI""")
    return 'Success'
