from common.dto import Dto


class ActionDTO(Dto):
    def __init__(self, pk, is_checked, num, edit, avatar, username):
        self.pk = pk
        self.isChecked = is_checked
        self.num = num
        self.edit = edit.isoformat() if edit is not None else None
        self.user = UserDTO(username=username, avatar=avatar)
        self.comments = []


class UserDTO(Dto):
    def __init__(self, username, avatar):
        self.username = username
        self.avatar = avatar


class CommentDTO(Dto):
    def __init__(self, pk, comment, avatar, username, creation):
        self.user = UserDTO(username=username, avatar=avatar)
        self.pk = pk
        self.comment = comment
        self.creation = creation.isoformat() if creation is not None else None


class AnalyzeDTO(Dto):
    def __init__(self, code):
        self.gtin_code = code
        self.gtin = False
        self.dpm = False
        self.image_1 = False
        self.image_2 = False
        self.xlsx = False
        self.xml = False
        self.structure = True
