import logging

from flask import Blueprint
from flask_jwt_extended import jwt_required
from median.models import Adresse

container_format_blueprint = Blueprint('container_format', __name__)

logger = logging.getLogger('median')


@container_format_blueprint.route('<string:mag>', methods=['GET'])
@jwt_required()
def get(mag):
    try:
        if not mag:
            cf = (Adresse.select(Adresse.format).distinct()
                  .order_by(Adresse.format))
        else:
            cf = (Adresse.select(Adresse.format).distinct()
                  .where(Adresse.magasin == mag).order_by(Adresse.format))
    except Exception as error:
        logger.error(error.args)
        return {'message': error.args}, 503

    logger.info('Lines : %s.' % len(cf))
    return ([{
        'format': c.format
    } for c in cf])
