from enum import Enum
from median.views import RawConfig


class DrugStandard(Enum):
    Pzn = 'pzn'
    Ucd = 'ucd'
    Cnk = 'cnk'


DRUGS_MAPPING = {
    "fr": DrugStandard.Ucd,
    "de": DrugStandard.Pzn,
    "be": DrugStandard.Cnk,
}


def get_drug_standard():
    """
    Return the drugs standard system base on the country code
    """
    config = RawConfig().read("k_drug_country")

    if config is None or not config.value:
        return DrugStandard.Ucd

    try:
        return DRUGS_MAPPING[config.value]
    except KeyError:
        return DRUGS_MAPPING["fr"]
