from flask import Blueprint
from flask_jwt_extended import jwt_required
from median.models import Stock
from common.status import HTTP_200_OK

batch_blueprint = Blueprint('batch', __name__)


@batch_blueprint.route('<string:ucd>', methods=['GET'])
@jwt_required()
def get_batch_ucd(ucd):
    list = Stock.select(Stock.lot.distinct().alias('batch')).where((Stock.ucd == ucd) & (Stock.quantite > 0))

    return {"list":
            [
                {
                    'lot': item.batch
                } for item in list
            ]}, HTTP_200_OK
