import json

from common.status import HTTP_200_OK, HTTP_500_INTERNAL_SERVER_ERROR, HTTP_204_NO_CONTENT
from flask import Blueprint, request
from flask_jwt_extended import jwt_required
from median.models import HistoriqueMultidoses
from peewee import DoesNotExist
from ressources.astus.multidoses.astus_multidoses_service import multidoses_request
from ressources.astus.multidoses.multiDoseDTO import MultiDoseDto

astus_multidoses_blueprint = Blueprint('astus_multidoses', __name__)


@astus_multidoses_blueprint.route('count', methods=['POST'])
@jwt_required()
def count():
    count = multidoses_request().count()
    return {
        'data': count
    }, HTTP_200_OK


@astus_multidoses_blueprint.route('<string:pk>', methods=['PUT'])
@jwt_required()
def update_qty(pk):
    data = json.loads(request.data)

    try:

        multidose = HistoriqueMultidoses.get(pk=pk)

        multidose.quantite_servi = int(data.get('qty', 0))
        multidose.save()

        return {}, HTTP_204_NO_CONTENT
    except DoesNotExist:
        return {'message': 'multidoses.error.unknown'}, HTTP_500_INTERNAL_SERVER_ERROR


@astus_multidoses_blueprint.route('', methods=['POST'])
@jwt_required()
def get_all():

    data = json.loads(request.data)
    page_size = data.get('pageSize', -1)
    page_number = data.get('page', -1)
    histo_prises = multidoses_request()

    if page_size > 0 and page_number >= 0:
        histo_prises = histo_prises.limit(page_size).offset(page_number * page_size)

    return {'list':
            [json.loads(MultiDoseDto(ipp=item.ipp, first_name=item.firstname, last_name=item.lastname,
                                     ward_code=item.ward_code, ward_label=item.ward_label,
                                     product_reference=item.ward_code, product_label=item.product_label,
                                     qty=int(item.qty_asked), qty_served=int(item.qty_served),
                                     coef_conv=item.coef_conv, manag_unit=item.manag_unit,
                                     admin_unit=item.admin_unit, expiration_delay=item.expiration_delay,
                                     date=item.date, stay_num=item.stay, pk=item.pk).toJson())
             for item in histo_prises]}, HTTP_200_OK
