import operator
from datetime import datetime, timedelta
from functools import reduce

from median.constant import HistoryType
from median.models import Seuil, Stock, Product, Magasin, Adresse, Historique
from peewee import fn, Value, JOIN, DoesNotExist


def get_obj_consumption(m):
    return {
        'last': m.last_picking,
        'reference': m.reference,
        'designation': m.designation,
        'quantity': m.quantity,
        'fraction': m.fraction,
        'min': m.stock_mini,
        'max': m.stock_maxi,
        'expiration': m.expiration,
        'replenish_lock': m.lock > 0,
        'reference_pk': m.reference_pk
    }


def get_consumption(type_mag, data):
    criterias = data.get('search', [])
    nb_jour = int(data.get('delay', 90))
    compare_date = (datetime.today() - timedelta(days=nb_jour))
    andexpr = (Magasin.type_mag == type_mag)
    if len(criterias) > 0:
        lst = list(map(lambda s: (
            (Adresse.adresse.contains(s.strip())) |
            (Stock.reference.contains(s.strip())) |
            (Product.designation.contains(s.strip()))
        ), criterias))
        search = reduce(operator.and_, lst)
        expr = reduce(operator.and_, [andexpr, search])
    else:
        expr = andexpr
    StockAlias = Stock.alias('StockAlias')

    list_conso = (Magasin.select(Magasin.type_mag,
                                 Stock.reference.alias('reference'),
                                 Product.designation.alias('designation'),
                                 Product.pk.alias('reference_pk'),
                                 fn.IFNULL(fn.SUM(Stock.quantite), 0).alias('quantity'),
                                 Stock.fraction.alias('fraction'),
                                 Seuil.stock_mini.alias('stock_mini'),
                                 Seuil.stock_maxi.alias('stock_maxi'),
                                 fn.SUM(Adresse.bloque_reappro).alias('lock'),
                                 (StockAlias.select(fn.MIN(StockAlias.date_peremption))
                                  .where((StockAlias.fraction == Stock.fraction) &
                                         (StockAlias.reference == Stock.reference) &
                                         (StockAlias.magasin == Magasin.mag))).alias('expiration'),
                                 Value('').alias('last_picking'))
                  .join(Adresse,
                        on=Adresse.magasin == Magasin.mag)
                  .switch(Magasin)
                  .join(Stock,
                        on=Stock.adresse == Adresse.adresse)
                  .switch(Magasin)
                  .join(Product,
                        on=Product.reference == Stock.reference)
                  .switch(Magasin)
                  .join(Seuil, JOIN.LEFT_OUTER,
                        on=(Seuil.reference == Stock.reference) &
                           (Seuil.zone == Magasin.type_mag) &
                           (Seuil.fraction == Stock.fraction))
                  .where(expr)
                  .group_by(Magasin.type_mag,
                            Stock.reference,
                            Product.designation)
                  .having(fn.SUM(Stock.quantite) > 0)).objects()

    for c in list_conso:
        try:
            last = (Historique.select(Historique.fraction.alias('fraction'),
                                      Historique.reference.alias('reference'),
                                      Historique.chrono.alias('last'))
                    .join(Magasin, on=Historique.adresse.startswith(Magasin.mag))
                    .where((Historique.type_mouvement << [HistoryType.Sortie.value])
                           & (Magasin.type_mag == type_mag)
                           & ((Historique.fraction == c.fraction) & (Historique.reference == c.reference)))
                    .order_by(Historique.chrono.desc())
                    .limit(1)).get()

            c.last_picking = last.last
        except DoesNotExist:
            c.last_picking = None

    return list(filter(lambda o: o.last_picking is None or o.last_picking <= compare_date, list(list_conso)))


def lock_comsumption_replenish(equipment_pk, references, is_lock):
    equipment = Magasin.select(Magasin.mag).where(Magasin.pk == equipment_pk).get()
    products = Product.select(Product.reference).where(Product.pk << references)

    refs = list(map(lambda o: o.reference, products))

    (Adresse.update(bloque_reappro=is_lock)
     .where((Adresse.emplacement << refs) & (Adresse.magasin == equipment.mag))
     .execute())
