from peewee import (
    AutoField,
    CharField,
    DateTimeField,
    ForeignKeyField, IntegerField,
)
from peewee import SQL
from ..base import WebModel


class WebImportRefHeader(WebModel):
    pk = AutoField(
        column_name='pk', primary_key=True)
    start = DateTimeField(
        column_name='start', constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    end = DateTimeField(
        column_name='end', null=True)
    user_pk = IntegerField(column_name='user_pk', index=True)

    class Meta:
        table_name = 'web_importref_header'


class WebImportRefLine(WebModel):
    pk = AutoField(
        column_name='pk', primary_key=True)
    header = ForeignKeyField(WebImportRefHeader, backref='lines', lazy_load=False)
    reference = CharField(column_name='reference', max_length=35)
    designation = CharField(column_name='designation', max_length=100)
    ucd = CharField(column_name='ucd', max_length=20)
    cip = CharField(column_name='cip', max_length=20)
    box_qty = IntegerField(column_name='box_qty', null=True)
    blister_qty = IntegerField(column_name='blister_qty', null=True)

    class Meta:
        table_name = 'web_importref_lines'
