from median.models import Label, Rights, Config
from peewee import DoesNotExist

INTERFACES_KEYS = [
    'k_ping', 'k_drugs', 'k_patient', 'k_episode', 'k_service',
    'k_dispensation', 'k_prescription', 'k_stock_in', 'k_stock_out', 'k_stock_delta',
    'k_stock_level', 'k_complement_globale', 'k_complement_nominatif'
]


def add_default_libelle():
    """Add default libelle"""
    Label.get_or_create(readonly=1, code="ref_dci", libelle="DCI")
    Label.get_or_create(readonly=1, code="ref_desig", libelle="Designation")
    Label.get_or_create(readonly=1, code="ref_desig_bis", libelle="Desig bis")
    Label.get_or_create(readonly=2, code="ref_adr_pref", libelle="Bufferstock Address", libelle_0="ADR")
    Label.get_or_create(
        readonly=0, code="ref_desig_bis", libelle="Replenish Mode", libelle_0="/api/acced/reappro/selectbox"
    )
    Label.get_or_create(readonly=0, code="ref_com_med", libelle="Commentaire")
    Label.get_or_create(readonly=2, code="ref_forme", libelle="Forme", libelle_0="/api/product/forme/selectbox")


def save_rights(ressource, libelle, group):
    rg, created = Rights.get_or_create(ressource=ressource, defaults={
        'libelle': libelle, 'group': group})
    if not created:
        rg.group = group
        rg.save()


def add_default_rights():
    save_rights(ressource='WEB_PRODUIT', libelle="MedianWeb\\REFERENCE\\Produit", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_ACCED', libelle="MedianWeb\\ACCED", group="GROUP_ACCED")
    save_rights(ressource='WEB_PRODUIT_PARAM', libelle="MedianWeb\\REFERENCE\\Param produit", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_PRODUIT_BATCH', libelle="MedianWeb\\REFERENCE\\Lot produit", group="GROUP_REFERENCE")

    save_rights(ressource='WEB_PRODUIT_BLACKLIST', libelle="MedianWeb\\REFERENCE\\Lot retiré", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_PRODUIT_THRESHOLD', libelle="MedianWeb\\REFERENCE\\Seuils", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_PRODUIT_PARAM_UCD', libelle="MedianWeb\\REFERENCE\\Param UCD CIP",
                group="GROUP_REFERENCE")
    save_rights(ressource='WEB_IDENTIFY', libelle="MedianWeb\\REFERENCE\\Identify product",
                group="GROUP_REFERENCE")
    save_rights(ressource='WEB_DASHBOARD', libelle="MedianWeb\\Tableau de bord", group="GROUP_DASHBOARD")
    save_rights(ressource='WEB_REAPPRO', libelle="MedianWeb\\ACCED\\Reappro", group="GROUP_ACCED")
    save_rights(ressource='WEB_ACCED_FEASIBILITY', libelle="MedianWeb\\ACCED\\Faisabilité", group="GROUP_ACCED")
    save_rights(ressource='WEB_HISTORY', libelle="MedianWeb\\Historique", group="GROUP_HISTORY")
    save_rights(ressource='WEB_HISTORY_INTERFACE', libelle="MedianWeb\\Historique Interface",
                group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_DISPENSATION', libelle="MedianWeb\\Dispensation", group="GROUP_ACCED")
    save_rights(ressource='WEB_LOCATIONS', libelle="MedianWeb\\Emplacements", group="GROUP_LOCATION")
    save_rights(ressource='WEB_PARAMETER', libelle="MedianWeb\\Paramètres", group="GROUP_SETTINGS")
    save_rights(ressource='WEB_USERS', libelle="MedianWeb\\Paramètres\\Utilisateurs", group="GROUP_SETTINGS")
    save_rights(ressource='WEB_DASHBOARD_STATS', libelle="MedianWeb\\ACCED\\Statistiques", group="GROUP_ACCED")
    save_rights(ressource='WEB_ACCED_FEASIBILITY', libelle="MedianWeb\\ACCED\\Compteur", group="GROUP_ACCED")
    save_rights(ressource='WEB_SERVICES', libelle="MedianWeb\\Services", group="GROUP_WARDS")
    save_rights(ressource='WEB_RIEDL', libelle="MedianWeb\\Riedl", group="GROUP_RIEDL")
    save_rights(ressource='WEB_RIEDL_INPUT', libelle="MedianWeb\\Entréee Riedl", group="GROUP_RIEDL")
    save_rights(ressource='WEB_RIEDL_OUTPUT', libelle="MedianWeb\\Sorties Riedl", group="GROUP_RIEDL")
    save_rights(ressource='WEB_RIEDL_EXCHANGE', libelle="MedianWeb\\Logs Echanges Riedl", group="GROUP_RIEDL")
    save_rights(ressource='WEB_ASTUS', libelle="MedianWeb\\Astus\\Tableau de bord", group="GROUP_ASTUS")
    save_rights(ressource='WEB_GROUP', libelle="MedianWeb\\Paramètres\\Groupes", group="GROUP_SETTINGS")
    save_rights(ressource='WEB_PEIGNES', libelle="MedianWeb\\Paramètres\\Peignes", group="GROUP_SETTINGS")
    save_rights(ressource='WEB_RIEDL_STOCK_EXPORT', libelle="MedianWeb\\Riedl\\Export stock", group="GROUP_RIEDL")
    save_rights(ressource='WEB_ASTUS_FEASIBILITY', libelle="MedianWeb\\ASTUS\\Faisabilité", group="GROUP_ASTUS")
    save_rights(ressource='WEB_REF_FORMAT', libelle="MedianWeb\\Reference\\Format", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_REF_ASTUS', libelle="MedianWeb\\Reference\\param astus", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_REF_RIEDL', libelle="MedianWeb\\Reference\\param riedl", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_ACCED_HISTORY_MESSAGES', libelle="MedianWeb\\ACCED\\historique messages",
                group="GROUP_ACCED")
    save_rights(ressource='WEB_WITHOUT_TRESHOLD', libelle="MedianWeb\\ACCED\\cwothreshold", group="GROUP_ACCED")
    save_rights(ressource='WEB_SETTING_ACCED_MESSAGES', libelle="MedianWeb\\ACCED\\messages", group="GROUP_ACCED")
    save_rights(ressource='WEB_ORGANILOG', libelle="MedianWeb\\organilog", group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_ACCED_ZERO_CONSUMPTION', libelle="MedianWeb\\ACCED\\consommation", group="GROUP_ACCED")
    save_rights(ressource='WEB_ACCED_WAITING_MESSAGES', libelle="MedianWeb\\ACCED\\WEB_ACCED_WAITING_MESSAGES",
                group="GROUP_ACCED")
    save_rights(ressource='WEB_ACCED_DETAIL', libelle="MedianWeb\\ACCED\\Detail", group="GROUP_ACCED")
    save_rights(ressource='WEB_PRESCRIPTION', libelle="MedianWeb\\Prescription", group="GROUP_PRESCRIPTION")
    save_rights(ressource='WEB_PICKING_REPORT', libelle="MedianWeb\\Documents", group="GROUP_DOCUMENT")
    save_rights(ressource='WEB_ASTUS_STOCK', libelle="MedianWeb\\astus\\Stock", group="GROUP_ASTUS")
    save_rights(ressource='WEB_ASTUS_DRAWER_SEARCH', libelle="MedianWeb\\astus\\recherche par tiroir",
                group="GROUP_ASTUS")
    save_rights(ressource='WEB_ASTUS_EVENTS', libelle="MedianWeb\\astus\\journaux d'évènements", group="GROUP_ASTUS")
    save_rights(ressource='WEB_ASTUS_REPLENISHMENT', libelle="MedianWeb\\astus\\réappro", group="GROUP_ASTUS")
    save_rights(ressource='WEB_ASTUS_DETAIL', libelle="MedianWeb\\astus\\détails", group="GROUP_ASTUS")
    save_rights(ressource='WEB_ASTUS_WARD_CONFIGURATION', libelle="MedianWeb\\astus\\configuration services",
                group="GROUP_ASTUS")
    save_rights(ressource='WEB_ASTUS_TOOLBOX', libelle="MedianWeb\\astus\\toolbox", group="GROUP_ASTUS")
    save_rights(ressource='WEB_SETTING_LANG', libelle="MedianWeb\\Paramètres\\Langues", group="GROUP_SETTINGS")
    save_rights(ressource='WEB_ASTUS_INVENTORY', libelle="MedianWeb\\astus\\inventaire", group="GROUP_ASTUS")
    save_rights(ressource='WEB_DASHBOARD_COMPTEUR', libelle="MedianWeb\\tableau de bord/compteurs",
                group="GROUP_DASHBOARD")
    save_rights(ressource='WEB_RISKY_DRUGS', libelle="MedianWeb\\historique\\tracabilité", group="GROUP_REFERENCE")
    save_rights(ressource='WEB_INVENTORY', libelle="MedianWeb\\reference\\inventaire",
                group="GROUP_REFERENCE")
    save_rights(ressource='WEB_ACTIONS', libelle="MedianWeb\\administration\\actions",
                group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_ADMINISTRATION', libelle="MedianWeb\\administration",
                group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_DPM', libelle="MedianWeb\\administration\\WEB_DPM",
                group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_ACCED_THRESHOLD_SIMULATOR', libelle="MedianWeb\\ACCED\\WEB_ACCED_THRESHOLD_SIMULATOR",
                group="GROUP_ACCED")
    save_rights(ressource='WEB_ASTUS_OUTPUT', libelle="MedianWeb\\ACCED\\WEB_ASTUS_OUTPUT",
                group="GROUP_ASTUS")
    save_rights(ressource='WEB_SETTINGS_BLOCKING_DEFECTS', libelle="MedianWeb\\SETTING\\WEB_SETTING_BLOCKING_DEFECTS",
                group="GROUP_SETTINGS")
    save_rights(ressource='WEB_SETTING_EQUIPMENT', libelle="MedianWeb\\Paramètres\\equipments",
                group="GROUP_SETTINGS")
    save_rights(ressource='WEB_CATALOG', libelle="MedianWeb\\Paramètres\\catalog",
                group="GROUP_SETTINGS")
    save_rights(ressource='WEB_SAVED_LIST', libelle="MedianWeb\\Acced\\saved_list",
                group="GROUP_ACCED")
    save_rights(ressource='WEB_BLOCKED_HISTORY', libelle="MedianWeb\\Emplacement\\Historique blocage",
                group="GROUP_LOCATION")
    save_rights(ressource='WEB_THRESHOLD', libelle="MedianWeb\\historique\\seuil",
                group="GROUP_HISTORY")
    save_rights(ressource='WEB_EXTERNAL', libelle="MedianWeb\\Paramètres\\externe",
                group="GROUP_EXTERNAL")
    save_rights(ressource='WEB_EXTERNAL_STOCK', libelle="MedianWeb\\externe\\WEB_EXTERNAL_STOCK",
                group="GROUP_EXTERNAL")
    save_rights(ressource='WEB_EXTERNAL_RETURNS', libelle="MedianWeb\\externe\\WEB_EXTERNAL_RETURNS",
                group="GROUP_EXTERNAL")
    save_rights(ressource='WEB_EXTERNAL_REPLENISH', libelle="MedianWeb\\externe\\WEB_EXTERNAL_REPLENISH",
                group="GROUP_EXTERNAL")
    save_rights(ressource='WEB_EXTERNAL_UNLOAD', libelle="MedianWeb\\externe\\WEB_EXTERNAL_UNLOAD",
                group="GROUP_EXTERNAL")
    save_rights(ressource='WEB_ACCED_STATS', libelle="MedianWeb\\ACCED\\WEB_ACCED_STATS",
                group="GROUP_ACCED")
    save_rights(ressource='WEB_DATA_FETCHER', libelle="MedianWeb\\ACCED\\WEB_DATA_FETCHER",
                group="GROUP_ACCED")  # TODO: Might have to move this elsewhere than ACCED

    # save_rights(ressource='WEB_NOTIFICATIONS_COUNTER', libelle="MedianWeb\\WEB_NOTIFICATIONS_COUNTER",
    #             group="GROUP_DASHBOARD")
    # save_rights(ressource='WEB_NOTIFICATIONS', libelle="MedianWeb\\WEB_NOTIFICATIONS",
    #             group="GROUP_DASHBOARD")
    save_rights(ressource='WEB_STOCK', libelle="MedianWeb\\WEB_STOCK",
                group="GROUP_REFERENCE")
    save_rights(ressource='WEB_RIEDL_REPLENISH', libelle="MedianWeb\\reidl\\WEB_RIEDL_REPLENISH",
                group="GROUP_RIEDL")
    save_rights(ressource='WEB_LOCATIONS_GENERATOR', libelle="MedianWeb\\settings\\WEB_LOCATIONS_GENERATOR",
                group="GROUP_SETTINGS")
    save_rights(ressource='WEB_ASTUS_CONSUMPTION', libelle="MedianWeb\\astus\\journaux d'évènements",
                group="GROUP_ASTUS")
    save_rights(ressource='WEB_ACCED_BLOCK_CAUSES', libelle="MedianWeb\\settings\\WEB_ACCED_BLOCK_CAUSES",
                group="GROUP_ACCED"),
    save_rights(ressource='WEB_PATIENTS', libelle="MedianWeb\\WEB_PATIENTS",
                group="GROUP_PATIENTS"),
    save_rights(ressource='WEB_MAGGROUPS', libelle="MedianWeb\\settings\\WEB_MAGGROUPS",
                group="GROUP_SETTINGS")
    save_rights(ressource='WEB_WSCLIENT_ERROR', libelle="MedianWeb\\Administration\\WEB_WSCLIENT_ERROR",
                group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_ASTUS_MULTI_DOSES', libelle="MedianWeb\\Astus\\WEB_ASTUS_MULTI_DOSES",
                group="GROUP_ASTUS")
    save_rights(ressource='WEB_PRINTERS', libelle="MedianWeb\\settings\\WEB_PRINTERS",
                group="GROUP_SETTINGS")
    save_rights(ressource='WEB_MEDICATION_COMPLETION', libelle="MedianWeb\\Administration\\WEB_MEDICATION_COMPLETION",
                group="GROUP_ADMINISTRATION")
    save_rights(ressource='WEB_AIDEPLUS', libelle="MedianWeb\\Aide_Plus\\WEB_AIDEPLUS",
                group="GROUP_AIDEPLUS")
    save_rights(ressource='WEB_AIDEPLUS_COMPLETION', libelle="MedianWeb\\Aide_Plus\\WEB_AIDEPLUS_COMPLETION",
                group="GROUP_AIDEPLUS")


def add_default_interfaces():
    """Add keys for interfaces ports"""
    i = 0
    for k in INTERFACES_KEYS:
        addr = k
        try:
            Config.get(poste='TOUS', cle='interface', propriete=addr)
            print('Interface %s key exists' % addr)
        except DoesNotExist:
            zpl_cfg = Config()
            zpl_cfg.ref_id = '_INTREF0%i' % (i + 1)
            zpl_cfg.poste = 'TOUS'
            zpl_cfg.cle = 'interface'
            zpl_cfg.propriete = addr
            zpl_cfg.type_value = 'C'
            zpl_cfg.value = 'Z'
            zpl_cfg.hierarchie_menu = """Interface\\ Etat %s""" % (k,)
            zpl_cfg.type_champ = 'reg'
            zpl_cfg.ordre = 10 + i
            zpl_cfg.save()
            print('Interface %s created' % addr)
        i += 1

        addr = k + "_date"
        try:
            Config.get(poste='TOUS', cle='interface', propriete=addr)
            print('Interface %s key exists' % addr)
        except DoesNotExist:
            zpl_cfg = Config()
            zpl_cfg.ref_id = '_INTREF0%i' % (i + 1)
            zpl_cfg.poste = 'TOUS'
            zpl_cfg.cle = 'interface'
            zpl_cfg.propriete = addr
            zpl_cfg.type_value = 'C'
            zpl_cfg.value = '0000-00-00 00:00:00'
            zpl_cfg.hierarchie_menu = """Interface\\Date %s""" % (k,)
            zpl_cfg.type_champ = 'reg'
            zpl_cfg.ordre = 10 + i
            zpl_cfg.save()
            print('Interface %s created' % addr)

        i += 1
