import logging
from datetime import datetime, timedelta
from median.models import ListeModel

logger = logging.getLogger("median.cleanup")


def clean_inventory(days: int = 15):
    d = datetime.today() - timedelta(days=days)

    inventories = ListeModel.select().where(ListeModel.mode == "I", ListeModel.date_creation < d)
    logger.info(f"Found {len(inventories)} inventories to cleanup")
    for inv in inventories:
        logger.info(f"delete inventory {inv.liste} from {inv.date_creation.strftime('%d/%m/%Y')}")
        print(f"delete inventory {inv.liste} from {inv.date_creation.strftime('%d/%m/%Y')}")
        inv.delete_instance()
