from peewee import SQL
from peewee import AutoField, CharField

from ..base import BaseModel


class Ucd(BaseModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    reference = CharField(
        column_name='x_ref', constraints=[SQL("DEFAULT ''")])
    ucd = CharField(
        column_name='x_ucd', constraints=[SQL("DEFAULT ''")])
    alpha_1 = CharField(
        column_name='x_alpha_1_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_2 = CharField(
        column_name='x_alpha_2_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_3 = CharField(
        column_name='x_alpha_3_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_4 = CharField(
        column_name='x_alpha_4_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_5 = CharField(
        column_name='x_alpha_5_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_6 = CharField(
        column_name='x_alpha_6_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_7 = CharField(
        column_name='x_alpha_7_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_8 = CharField(
        column_name='x_alpha_8_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_9 = CharField(
        column_name='x_alpha_9_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')
    alpha_10 = CharField(
        column_name='x_alpha_10_bis', null=True, max_length=100, constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_ref_ucd'
        indexes = (
            (('x_ref', 'x_ucd'), True),
            (('x_ref',), False),
            (('x_ucd',), False),
            (('x_alpha_1_bis',), False),
        )
