from peewee import (
    AutoField,
    CharField,
    IntegerField,
    DateTimeField,
    TextField
)
from peewee import SQL

from ..base import BaseModel


class Prescription(BaseModel):

    pk = AutoField(column_name="x_pk", primary_key=True)
    ordre = CharField(column_name="x_ordre", null=True, constraints=[SQL("DEFAULT ''")])
    ipp = CharField(column_name="x_ipp", constraints=[SQL("DEFAULT ''")])
    sejour = CharField(
        column_name="x_sejour", null=True, constraints=[SQL("DEFAULT ''")]
    )
    nom = CharField(column_name="x_nom", null=True, constraints=[SQL("DEFAULT ''")])
    prenom = CharField(
        column_name="x_prenom", null=True, constraints=[SQL("DEFAULT ''")]
    )
    date_naissance = DateTimeField(
        column_name="x_dtnaiss",
        null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],
    )
    sexe = CharField(
        column_name="x_sexe", null=True,
        constraints=[SQL("DEFAULT ''")]
    )
    chambre = CharField(
        column_name="x_chambre", null=True, constraints=[SQL("DEFAULT ''")]
    )
    lit = CharField(column_name="x_lit", null=True, constraints=[SQL("DEFAULT ''")])
    nom_jeune_fille = CharField(column_name="x_nomjf", null=True, constraints=[SQL("DEFAULT ''")])
    demande = IntegerField(
        column_name="x_demande", null=True, constraints=[SQL("DEFAULT 0")]
    )

    class Meta:
        table_name = "f_prescription"


class PrescriptionItem(BaseModel):

    pk = AutoField(
        column_name="x_pk", primary_key=True)
    ordre = CharField(
        column_name="x_ordre", max_length=35)
    ipp = CharField(
        column_name="x_ipp", max_length=30)
    sejour = CharField(
        column_name="x_sejour", max_length=35)
    service = CharField(
        column_name="x_dest", max_length=30, null=True)
    sequence = IntegerField(
        column_name="x_sequence", constraints=[SQL("DEFAULT 0")])
    sub_sequence = IntegerField(
        column_name="x_sub_sequence", constraints=[SQL("DEFAULT 1")])
    reference = CharField(
        column_name="x_ref", max_length=35, null=True)
    date_debut = DateTimeField(
        column_name="x_date_debut", null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],)
    date_fin = DateTimeField(
        column_name="x_date_fin", null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")],)
    posologie = TextField(column_name="x_posologie", null=True)

    class Meta:
        table_name = "f_prescription_item"
        indexes = (
            (('x_ipp', 'x_sejour'), False),
            (('x_ordre', ), False),
        )
