from peewee import (
    IntegerField,
    CharField,
    BooleanField,
    AutoField,
    ForeignKeyField
)
from peewee import SQL
from ..base import InnodbModel


class LdapServer(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    server_address = CharField(
        column_name='x_server', null=True, max_length=128)
    server_port = IntegerField(
        column_name='x_port', null=True)
    dn = CharField(
        column_name='x_dn', null=True, max_length=256)
    username = CharField(
        column_name='x_user', null=True, max_length=64)
    password = CharField(
        column_name='x_pass', null=True, max_length=64)
    secure = BooleanField(
        column_name='x_secure', null=True, constraints=[SQL("DEFAULT 0")], default=0)
    search_base = CharField(
        column_name='x_search_base', null=True, max_length=256,
        constraints=[SQL("DEFAULT ''")], default='')

    class Meta:
        table_name = 'f_annuaire'
        indexes = (
            (('x_server', 'x_port'), True),
            (('x_dn',), False),
        )


class LdapServerProfil(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    profil = CharField(
        column_name='x_profil', null=True, max_length=20)
    dn = CharField(
        column_name='x_dn', null=True, max_length=256)
    narcotic_auth = BooleanField(
        column_name='x_astup', null=True)
    annuaire_id = ForeignKeyField(
        LdapServer, column_name='x_annuaire', backref='servers',
        lazy_load=True, on_delete='CASCADE', on_update='CASCADE')
    filter = CharField(
        column_name='x_filter', null=True, max_length=256,
        constraints=[SQL("DEFAULT '(ObjectClass=User)'")],
        default='(ObjectClass=User)')
    subtree = BooleanField(
        column_name='x_subtree', null=True, constraints=[SQL("DEFAULT 0")], default=0)

    class Meta:
        table_name = 'f_user_ad'
        indexes = (
            (('x_profil',), False),
            (('x_dn',), False),
            (('annuaire_id',), False),
        )
