from peewee import AutoField, CharField, IntegerField, DateTimeField
from peewee import SQL

from ..base import InnodbModel
from ..database import TinyIntegerField


class DataExtract(InnodbModel):

    pk = AutoField(
        column_name='x_pk', primary_key=True)
    chrono = DateTimeField(
        column_name='x_chrono',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    user = CharField(
        column_name='x_user', null=True, max_length=60, constraints=[SQL("DEFAULT ''")], default='')
    ipp = CharField(
        column_name='x_ipp', constraints=[SQL("DEFAULT ''")])
    ward = CharField(
        column_name='x_ward', constraints=[SQL("DEFAULT ''")])
    id_import = IntegerField(
        column_name='x_id_import', constraints=[SQL("UNIQUE"), SQL("DEFAULT 0")], default=0)
    moment_morning = TinyIntegerField(
        column_name='x_moment_morning', constraints=[SQL("DEFAULT 0")], default=0)
    moment_midday = TinyIntegerField(
        column_name='x_moment_midday', constraints=[SQL("DEFAULT 0")], default=0)
    moment_evening = TinyIntegerField(
        column_name='x_moment_evening', constraints=[SQL("DEFAULT 0")], default=0)
    moment_night = TinyIntegerField(
        column_name='x_moment_night', constraints=[SQL("DEFAULT 0")], default=0)
    moment_undefined = TinyIntegerField(
        column_name='x_moment_undefined', constraints=[SQL("DEFAULT 0")], default=0)
    date_start = DateTimeField(
        column_name='x_dstart',
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])
    date_end = DateTimeField(
        column_name='x_dend', null=True,
        constraints=[SQL("DEFAULT '0000-00-00 00:00:00'")])

    class Meta:
        table_name = 'f_data_extract'
        indexes = (
            (('x_id_import',), True),
            (('x_chrono',), False),
        )
